﻿//Uber Shader build on top of the Uber Adv + RGB Diffuse Tint
//This shader adds a dirt layer on top.

Shader "!FullControl/Uber/Uber Advanced + RGB Diffuse Tint + Dirt Map" 
{
	Properties 
	{
		//Diffuse Properties
		_MainTex ("Albedo (RGB) | SpecMask (A)", 2D) = "grey" {}
		_MainColor ("Albedo Tint Color", Color) = (1, 1, 1, 1)
		_MainMask ("Albedo Mask (RGB)", 2D) = "black" {}
		_ColorTintR ("Albedo Red Color", Color) = (1, 1, 1, 1)
		_ColorTintG ("Albedo Green Color", Color) = (1, 1, 1, 1)
		_ColorTintB ("Albedo Blue Color", Color) = (1, 1, 1, 1)
	
		//Dirt Properties
		_DirtTex ("Dirt Map (RGB)", 2D) = "black" {}
		_DirtMask ("Dirt Mask (RGB)", 2d) = "white" {}
		_DirtBlendInt ("Dirt Blend Intesity", Range (0.1, 1)) = 0
		
		//NormalMap Properties
		_BumpMap ("Normal Map", 2D) = "bump" {}
		
		//Specular Properties
		_SpecColor ("Spec Color", Color) = (1, 1, 1, 1)
		_SpecularPower ("Spec Power", Range (0.01, 5)) = 0.078125
		_SpecularIntensity ("Specular Intensity", float) = 0
		
		//RimLight Properties
		_RimLightColor ("RimLight Color", Color) = (1,1,1,1)
		_RimLightFalloff ("RimLight Fresnell", float) = 1 
		_RimLightIntensity ("RimLight Intensity", float) = 0
		
		//Reflection Properties
		_Cubemap ("Reflection Cubemap", CUBE) = "black" {}
		_ReflectionColor ("Reflection Color", Color) = (1,1,1,1)
		_ReflectionFalloff ("Reflection Fresnell", float) = 1 
		_ReflIntensity ("Reflection Intensity", float) = 0
		
		//Emission Properties
		_EmissionColor ("Emission Color", Color) = (0,0,0,0)
		_EmissionTex ("Emission Map", 2D) = "black" {}
		_EmissionInt ("Emission Intensity", float) = 0.0
	}
	
	SubShader 
	{
		Tags {"Queue"="Geometry"}
		
		LOD 200
		
		CGPROGRAM
		#pragma target 3.0
		#pragma surface surf BlinnPhong
		#pragma glsl
		
		//Diffuse
		float4 _MainColor;
		float4 _ColorTintR;
		float4 _ColorTintG;
		float4 _ColorTintB;
		sampler2D _MainTex;
		sampler2D _MainMask;
		sampler2D _BumpMap;
		
		//Dirt
		sampler2D _DirtTex;
		sampler2D _DirtMask;
		float _DirtBlendInt;
		
		//Specular
		float4 _SpecularColor;
		float _SpecularPower;
		float _SpecularIntensity;
		
		//RimLight
		float4 _RimLightColor;
		float _RimLightFalloff;
		float _RimLightIntensity;
		
		//Reflection
		samplerCUBE _Cubemap;
		float4 _ReflectionColor;
		float _ReflIntensity;
		float _ReflectionFalloff;
		
		//Emission
		sampler2D _EmissionTex;
		float4 _EmissionColor;
		float _EmissionInt;


		struct Input 
		{
			float2 uv_MainTex;
			float2 uv_MainMask;
			float2 uv_DirtTex;
			float2 uv_DirtMask;
			float3 worldRefl;
			float3 viewDir;
			INTERNAL_DATA
		};
		

		void surf (Input IN, inout SurfaceOutput o) 
		{
			//Diffuse
			half4 difTxt = tex2D (_MainTex, IN.uv_MainTex);
			half3 normalMap = UnpackNormal(tex2D(_BumpMap, IN.uv_MainTex));
			half4 dirtTxt = tex2D (_DirtTex, IN.uv_DirtTex);
			half4 dirtMask = tex2D (_DirtMask, IN.uv_DirtMask);
			
			o.Normal = normalMap;
			
			//RimLight
			half rim = 1.0 - saturate(dot(o.Normal, normalize(IN.viewDir)));
			half3 finalRim = _RimLightColor.rgb * pow (rim, _RimLightFalloff) * _RimLightIntensity;
			
			//Reflection
			rim = pow(rim, _ReflectionFalloff);
			half3 reflectionMask = lerp (difTxt.a, dirtTxt.a, dirtMask.rgb * _DirtBlendInt);
			half3 finalRefl = texCUBE (_Cubemap, WorldReflectionVector (IN, o.Normal)).rgb * reflectionMask * _ReflIntensity * rim * _ReflectionColor;
			
			//Emission
			half3 emissionTex = tex2D (_EmissionTex, IN.uv_MainTex);
			o.Emission = finalRefl + finalRim + ((emissionTex + _EmissionColor) * _EmissionInt);
			
			//Specular
			o.Gloss = reflectionMask * _SpecularIntensity;
			o.Specular = _SpecularPower * (difTxt.a * 2);
			
			//Albedo
			half4 difMask = tex2D (_MainMask, IN.uv_MainMask);		
			half3 albedoRGB = (difTxt.rgb * difMask.r * _ColorTintR) + (difTxt.rgb * difMask.g * _ColorTintG) + (difTxt.rgb * difMask.b * _ColorTintB);
			half3 albedoDiffuse = (1-(difMask.r + difMask.g + difMask.b)) * difTxt.rgb;
			
			o.Albedo = (lerp ((albedoDiffuse + albedoRGB), dirtTxt.rgb, dirtMask.rgb * _DirtBlendInt)) * _MainColor;
			//o.Albedo = dirtMask.rgb;
		}
		ENDCG
	}
	//Disabled during development
	FallBack "Diffuse"
}
